//
//  3D Wavy Plane.js
//  (c) 2006, 2011 Hiroto Tsubaki
//  http://www.tres-graficos.jp/
//  tg@tres-graficos.jp
//  
// 
//  v.20111110
// 2006-05-12 : first version.
// 2011-11-10 : added parameters.

// I checked it with version.2.6.1 and version.3.2.
// Usage: Place this into scripts/Polygonobj folder. restart Cheetah3D, then select from Tools -> Script -> Polygon Script
//

function buildUI(obj){
    obj.setParameter("name","3D Wavy Plane");
    
    obj.addParameterFloat("width",1,0,5000,true,true);
    obj.addParameterFloat("height",1,0,5000, true, true);
    
    obj.addParameterInt("section width",10,1,1000,true,true);
    obj.addParameterInt("section height",10,1,1000,true,true);
    
    obj.addParameterFloat("wave w count",2,0,10000,true,true);
    obj.addParameterFloat("wave h count",2,0,10000,true,true);
    obj.addParameterFloat("wave w start",0,-10000,10000,true,true);
    obj.addParameterFloat("wave h start",0,-10000,10000,true,true);
    
    obj.addParameterFloat("wave scale",0.3,-10000,10000,true,true);
    
    obj.addParameterSelector("wave type", ["sine", "sine-h abs", "sine-both abs"], true, true);
    
    //obj.addParameterFloat("random factor",0.01,-5,5,true,true);
    
	obj.addParameterSeparator("Smooth");
	obj.addParameterSelector("smooth",["normalFlat","normalPhong","normalContraint"],true,true);
	obj.addParameterFloat("smooth angle",45,1,180,true,true);
    
    obj.setParameter("smooth",1);
}

function buildObject(obj){
    var core = obj.core();
    
    var i, j;
    var width = obj.getParameter("width");
    var height = obj.getParameter("height");
    
    var sec_w = obj.getParameter("section width");
    var sec_h = obj.getParameter("section height");
    
    var wc = obj.getParameter("wave w count");
    var hc = obj.getParameter("wave h count");
    
    var wstart = obj.getParameter("wave w start");
    var hstart = obj.getParameter("wave h start");
    
    var ws = obj.getParameter("wave scale");
    
    var wtype = obj.getParameter("wave type");
    
    //var rf = obj.getParameter("random factor");
    
    var verts = new Array();
    var uvs = new Array();
    
    var rtw = Math.PI/sec_w*wc;
    var rth = Math.PI/sec_h*hc;
    
    obj.setParameter("normalType",obj.getParameter("smooth"),false);
    obj.setParameter("normalAngle",obj.getParameter("smooth angle"),false);
    
    switch(wtype) {
        case 0:
            var waveFuncW = function(v) { return Math.sin( v ); };
            var waveFuncH = function(v) { return Math.sin( v ); };
            break;
        case 1:
            var waveFuncW = function(v) { return Math.sin( v ); };
            var waveFuncH = function(v) { return Math.abs( Math.sin( v ) ); };
            break;
        case 2:
            var waveFuncW = function(v) { return Math.abs( Math.sin( v ) ); };
            var waveFuncH = function(v) { return Math.abs( Math.sin( v ) ); };
            break;
    }
    
    core.buildVertexBSP(new Vec3D(0, -ws, 0), new Vec3D(width, ws, height));
    
    var y_a1 = 0.0;
    var y_a2 = 0.0;
    var y_b1 = 0.0;
    var y_b2 = 0.0;
    
    var ws_a = 0.0;
    var ws_b = 0.0;
    var hs_a = 0.0;
    var hs_b = 0.0;
    
    var rf_a = 0.0;
    var rf_b = 0.0;
    
    verts[0] = new Vec3D(0,0,0);
    verts[1] = new Vec3D(0,0,0);
    verts[2] = new Vec3D(0,0,0);
    verts[3] = new Vec3D(0,0,0);
    
    uvs[0] = new Vec2D(0,0);
    uvs[1] = new Vec2D(0,0);
    uvs[2] = new Vec2D(0,0);
    uvs[3] = new Vec2D(0,0);
    
    ws_a = waveFuncW( hstart )*ws;
    for (j = 0;j < sec_h;j++) {
        ws_b = waveFuncW( rth*(j+1)+hstart )*ws;
        
        y_a1 = waveFuncH( wstart ) * ws_a;
        y_a2 = waveFuncH( wstart ) * ws_b;
        for (i = 0;i < sec_w;i++) {
            
            y_b1 = waveFuncH( rtw*(i+1)+wstart )*ws_a;
            y_b2 = waveFuncH( rtw*(i+1)+wstart )*ws_b;
            
            verts[0] = new Vec3D((width / sec_w) * (i + 1), y_b1, (height / sec_h) * j);
            verts[1] = new Vec3D((width / sec_w) * (i + 1), y_b2, (height / sec_h) * (j + 1));
            verts[2] = new Vec3D((width / sec_w) * i, y_a2, (height / sec_h) * (j + 1));
            verts[3] = new Vec3D((width / sec_w) * i, y_a1, (height / sec_h) * j);
            
            uvs[0] = new Vec2D((1/sec_w)*(i+1), (1/sec_h)*j);
            uvs[1] = new Vec2D((1/sec_w)*(i+1), (1/sec_h)*(j+1));
            uvs[2] = new Vec2D((1/sec_w)*i, (1/sec_h)*(j+1));
            uvs[3] = new Vec2D((1/sec_w)*i, (1/sec_h)*j);
            
            core.addPolygon(4,true,verts,uvs);
            
            y_a1 = y_b1;
            y_a2 = y_b2;
        }
        
        ws_a = ws_b;
    }
    
    core.destroyVertexBSP();
}



